<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Entidade') }}
        </h2>
    </x-slot>
    
    <div class="py-12 pt-10">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <table class="w-full">
                        <thead class="border-b border-gray-700">
                            <th class="font-bold text-left px-4 py-4">Dados da Entidade</th>
                        </thead>
                        <tbody>
                           <?php $counter=0;  ?>
                                <tr>
                                    <td>
                                        <span class="font-normal w-[65%]"><b>Nome: </b>{{$Entidade->nome}}</span>
                                        <br>
                                        <span class="font-normal w-[65%]"><b>Descrição: </b>{{$Entidade->descricao}}</span>
                                        <br>
                                        <span class="font-normal w-[65%]"><b>Sobre:</b> {{$Entidade->sobre}}</span>
                                        <br>
                                        <span class="font-normal w-[65%]"><b>Telefone:</b> {{$Entidade->telefone}}</span>
                                        <br>
                                        <span class="font-normal w-[65%]"><b>Email:</b> {{$Entidade->email}}</span>
                                        <br>
                                        <span class="font-normal w-[65%]"><b>Data de fundação:</b> {{ $Entidade->fundacao/*." 00:00:00"->format("d/m/Y") */}}</span>
                                        <br>
                                        <span class="font-normal w-[65%]"><b>Cadastrado aos </b>{{ $Entidade->created_at->format("d/m/Y h:i:s") }}</span>
                                        <br>
                                        <span class="font-normal w-[65%]"><b>Actualizado aos </b>{{ $Entidade->updated_at->format("d/m/Y h:i:s") }}</span>
                                    </td>
                                    <td>
                                        @if ($Entidade->logotipo==null or $Entidade->logotipo=='')
                                            <span class="font-normal w-[65%]">
                                                <a href="{{ asset('assets/img/user/sem-foto.jpg') }}" target="_blank">
                                                    <img src="{{ asset('assets/img/user/sem-foto.jpg') }}" alt="Image" style="width: 100px; height: 100px;">
                                                </a>
                                            </span>
                                        @else
                                            <span class="font-normal w-[65%]">
                                                <a href="{{asset('assets/img/user/') }}/{{ $Entidade->logotipo }}" target="_blank" rel="noopener noreferrer">
                                                    <img src="{{asset('assets/img/user/') }}/{{ $Entidade->logotipo }}" style="width: 100px; height: 100px;">
                                                </a>
                                            </span>
                                        @endif
                                        

                                    </td>
                                    
                                </tr> 
                        </tbody>
                    </table>
                    
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
